#!/usr/bin/env python

import pymongo
import os
import argparse

parser = argparse.ArgumentParser(
    description="Dump the tweets of a database to a JSON file")
parser.add_argument("-H", "--host", type=str, default="localhost")
parser.add_argument("-p", "--port", type=int, default=27017)
parser.add_argument("database", type=str)
args = parser.parse_args()

client = pymongo.MongoClient(args.host, args.port)
database_tweets = client[args.database]["tweets"]

output_dir = os.path.join(os.path.dirname(__file__), "pymongodump")
if not os.path.exists(output_dir):
    os.mkdir(output_dir)

with open(os.path.join(output_dir, args.database + ".json"), "a+") as f:
    for tweet in database_tweets.find():
        f.write(str(tweet) + "\n")
